﻿#
# This script just calls the Add-AppDevPackage.ps1 script that lives next to it.
#

param(
    [switch]$Force = $false,
    [switch]$SkipLoggingTelemetry = $false
)

$scriptArgs = ""
if ($Force)
{
    $scriptArgs = '-Force'
}

if ($SkipLoggingTelemetry)
{
    if ($Force)
    {
        $scriptArgs += ' '
    }

    $scriptArgs += '-SkipLoggingTelemetry'
}

try
{
    # Log telemetry data regarding the use of the script if possible.
    # There are three ways that this can be disabled:
    #   1. If the "TelemetryDependencies" folder isn't present.  This can be excluded at build time by setting the MSBuild property AppxLogTelemetryFromSideloadingScript to false
    #   2. If the SkipLoggingTelemetry switch is passed to this script.
    #   3. If Visual Studio telemetry is disabled via the registry.
    $TelemetryAssembliesFolder = (Join-Path $PSScriptRoot "TelemetryDependencies")
    if (!$SkipLoggingTelemetry -And (Test-Path $TelemetryAssembliesFolder))
    {
        $job = Start-Job -FilePath (Join-Path $TelemetryAssembliesFolder "LogSideloadingTelemetry.ps1") -ArgumentList $TelemetryAssembliesFolder, "VS/DesignTools/SideLoadingScript/Install", $null, $null
        Wait-Job -Job $job -Timeout 60 | Out-Null
    }
}
catch
{
    # Ignore telemetry errors
}

$currLocation = Get-Location
Set-Location $PSScriptRoot
Invoke-Expression ".\Add-AppDevPackage.ps1 $scriptArgs"
Set-Location $currLocation
# SIG # Begin signature block
# MIImLQYJKoZIhvcNAQcCoIImHjCCJhoCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCC7kxV/l3biwCGH
# VuAKUAkPVeCZ2LSQIMJf+ROzV3B37KCCC3YwggT+MIID5qADAgECAhMzAAAFVskg
# Kx90Ml0tAAAAAAVWMA0GCSqGSIb3DQEBCwUAMH4xCzAJBgNVBAYTAlVTMRMwEQYD
# VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
# b3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29mdCBDb2RlIFNpZ25p
# bmcgUENBIDIwMTAwHhcNMjMxMDE5MTk1MTExWhcNMjQxMDE2MTk1MTExWjB0MQsw
# CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
# ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMR4wHAYDVQQDExVNaWNy
# b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
# AQCW2kg89zWnssiDG9AFq/sxqkPT43V4MZ6vwu7C4+sly46QJA4UNxSRnGDz9u8f
# 18OR1/Ar9guQDqRthrOOktLaol49HZfv8l1DEeB/uguWS0qFIJe+cK6b7grVfl0S
# Z7U8yOXu67n52z+QJN+iUxcIk0KWcu/sJZ8KfewKxnNDMDIHHhUHvIjQWhvKxOLC
# /TwL0i4wTykXuQwbwIZuuGi7TYA82Q2LkYOLlwOTPOb0eowhcUI7CaXlU30IgoG4
# frY+mtZMZnTx0ga/a36GVNdq6NeBKzlGbLB02/WIP+c5ADDCXsheWpkizJt9aPhz
# Yuont+Nx0OhIH04lJFvCqjljAgMBAAGjggF9MIIBeTAfBgNVHSUEGDAWBgorBgEE
# AYI3PQYBBggrBgEFBQcDAzAdBgNVHQ4EFgQUJt8FhQFwX7g5A/0elDxkjww82dow
# VAYDVR0RBE0wS6RJMEcxLTArBgNVBAsTJE1pY3Jvc29mdCBJcmVsYW5kIE9wZXJh
# dGlvbnMgTGltaXRlZDEWMBQGA1UEBRMNMjMwODY1KzUwMTY1NTAfBgNVHSMEGDAW
# gBTm/F97uyIAWORyTrX0IXQjMubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8v
# Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
# MjAxMC0wNy0wNi5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRw
# Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8yMDEw
# LTA3LTA2LmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IBAQBCnZlo
# MxjHBVHJEP6d+0t7EDJfNB0h7j9iOX6LQiPMdQAV1xqA6Jgb/VEPSEVs076CAJn3
# KP5Jpr4DOuo12BE2CoCusZDHn+7aP2yxngMGGQcJKz4UfOzDMS9Yr2sl3R6fMP18
# T4Ce5t7IYFK36PI/HfvHO8AzB3T0KhVIifqsSwZ8mEukw/wi4duJYulYxV2lY2kM
# Hwv/OKvKAsrTd338HlnuR+z9NZvStNUi1a8sTwcEMrEP8lgtoxaZe0Ypu/Ohn4Pq
# TefEVWKQJLU2KFyLDkoamDde0ydAzzHYEqdBQMW0gxWyvJ9fjgF/C2PKQVu/0SMB
# hcwo04eFzf/w7pZ/MIIGcDCCBFigAwIBAgIKYQxSTAAAAAAAAzANBgkqhkiG9w0B
# AQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
# BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAG
# A1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAw
# HhcNMTAwNzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYDVQQGEwJVUzET
# MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
# TWljcm9zb2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
# aWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# 6Q5kUHlntcTj/QkATJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX0o/9
# RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe0dLCiR5xlM21f0u0rwjYzIjW
# axeUOpPOJj/s5v40mFfVHV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
# vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IUyMHIiiYKWX8H7P8O7YAS
# NUwSpr5SW/Wm2uCLC0h31oVH1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZ
# M4BqiU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYBBAGCNxUBBAMCAQAw
# HQYDVR0OBBYEFOb8X3u7IgBY5HJOtfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoA
# UwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQY
# MBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjEMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6
# Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jvb0NlckF1
# dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0
# dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0XzIw
# MTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8GCSsGAQQBgjcuAzCBgTA9Bggr
# BgEFBQcCARYxaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
# ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUAZwBhAGwAXwBQAG8AbABp
# AGMAeQBfAFMAdABhAHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEA
# GnTvV08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI4zSp24G43B4AvtI1
# b6/lf3mVd+UC1PHr2M1OHhthosJaIxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMh
# KeWloWmMIpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxphnY9UdumOUjJ
# N2FtB91TGcun1mHCv+KDqw/ga5uV1n0oUbCJSlGkmmzItx9KGg5pqdfcwX7RSXCq
# tq27ckdjF/qm1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVBy78dTMgW
# 77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1zNfM8rlSyUkdqwKoTldKOEdqZZ14y
# jPs3hdHcdYWch8ZaV4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7beBVaX
# evfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7KsYxuqh3khdpHM2KPpMmRM19x
# HkCvmGXJIuhCISWKHC1g2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
# HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteSLM43Wj5AQjGkHxAIwlac
# vyRdUQKdannSF9PawZSOB3slcUSrBmrm1MbfI5qWdcUxghoNMIIaCQIBATCBlTB+
# MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
# bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9N
# aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAAFVskgKx90Ml0tAAAA
# AAVWMA0GCWCGSAFlAwQCAQUAoIGuMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEE
# MBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJBDEiBCC5
# 5sfwy7JnuBF0jRtZGRnrFzHJ1nC8iR8tv9OzWMo65TBCBgorBgEEAYI3AgEMMTQw
# MqAUgBIATQBpAGMAcgBvAHMAbwBmAHShGoAYaHR0cDovL3d3dy5taWNyb3NvZnQu
# Y29tMA0GCSqGSIb3DQEBAQUABIIBACUX8CcBNmT0N5gn3K0BxaRMd6VZO0nitxyx
# hz+0VVv+DO9t4KRbZl2BeFeT/vskjYmS9xeCRwLLc0YmB4xP31ML5UJFu5h2rLXs
# 2D9b1Ki02ggMyk5JSt8EWCngZOytCZdyndCTbL6C0yuVpONOPlkkU7x3v319N08D
# mzfTomnrytPNVA1AaVc6BtsptAoYoNlrw/ri+6VsxLmbnKMVhstWsn49IqqcN6yZ
# 0HO1PJMuGXkag3xZw92X0Q/3nE4sROuIy3uVHApvy/poa0P4O8wAhikyyS6UHQFP
# r+9BeMXCiLsfOw/iN2Bp67OJ7G7YA04oTAkjXfT2UOYOM2fmb1uhgheXMIIXkwYK
# KwYBBAGCNwMDATGCF4Mwghd/BgkqhkiG9w0BBwKgghdwMIIXbAIBAzEPMA0GCWCG
# SAFlAwQCAQUAMIIBUgYLKoZIhvcNAQkQAQSgggFBBIIBPTCCATkCAQEGCisGAQQB
# hFkKAwEwMTANBglghkgBZQMEAgEFAAQgRw8trhHZiWpHG0Z55pJ/RQQbnOPnXGEi
# jZT1UpO0M3cCBmXzLCMOzRgTMjAyNDAzMjgxODQxNDkuNDMyWjAEgAIB9KCB0aSB
# zjCByzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
# B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjElMCMGA1UE
# CxMcTWljcm9zb2Z0IEFtZXJpY2EgT3BlcmF0aW9uczEnMCUGA1UECxMeblNoaWVs
# ZCBUU1MgRVNOOkUwMDItMDVFMC1EOTQ3MSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
# ZS1TdGFtcCBTZXJ2aWNloIIR7TCCByAwggUIoAMCAQICEzMAAAHuBdMCMLKanacA
# AQAAAe4wDQYJKoZIhvcNAQELBQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
# c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
# b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIw
# MTAwHhcNMjMxMjA2MTg0NTQ0WhcNMjUwMzA1MTg0NTQ0WjCByzELMAkGA1UEBhMC
# VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
# BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjElMCMGA1UECxMcTWljcm9zb2Z0IEFt
# ZXJpY2EgT3BlcmF0aW9uczEnMCUGA1UECxMeblNoaWVsZCBUU1MgRVNOOkUwMDIt
# MDVFMC1EOTQ3MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNl
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAvvG8pdeihImvMSkuL1S+
# 0RDjkey82Ai1xLVoHqsjlZa87hM/gKAmuLQRhEo2x01xAnjDsD/Uz3imimpX01OV
# 0ho6SYaRsefX8TCaE2Fj88w9DtkQJcgZjgQZoiw10Q0CS9UbbgI7woi7pVUHojyP
# Fe/h4U0d/dU2wtW3kscF33SiamNaJ4w2sKgyQJrcLAP4Jql4B8BfX2VnMCkrl4mQ
# U21OX3Jt24YZUTcOXdOC3deWVs1Zf1Q6f4kXqxqNiLP9FsJ/2t3hjnR6738CG35O
# pVasGzUBNdTnnZ9rr0YylhMHq1y+9Drg2fLy88a8tMhHb0PJMvlX6vJnxF0vdO2O
# 6zfx2F+nArAtrKMlxtzsArSwO6NP/pCiWbjqw+R1K0s95H6oA5Zlsuu8/GWT45Ig
# wtXWFtYze+7eYkpeVqdRygaeyVPEYkSPr2NotXG+V9kRJMN1qzVv426H1xLPbeG4
# HfslPLICp/TLVZ0OubOkBu9jP8mlGRthzCN9bZvZqKB9vbzwTvYwzDiLtC8M1E5C
# Fn5YHf7xFn0zXD1hEI+37FrkqFbid7gasDZkUqZkA80nzGiM7srNKb1dYxVqrasM
# AnGmP1l7G/2sZMQf8wk3R0gVCfE5t4uDzPbJIrp12PnEqh+fI1pKR22ywNzn7LO3
# viWzIypk3XI5kpG+aDfKlNcCAwEAAaOCAUkwggFFMB0GA1UdDgQWBBQQiM0/Gtnc
# IJ69+8Xftr9f3HamCDAfBgNVHSMEGDAWgBSfpxVdAF5iXYP05dJlpxtTNRnpcjBf
# BgNVHR8EWDBWMFSgUqBQhk5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3Bz
# L2NybC9NaWNyb3NvZnQlMjBUaW1lLVN0YW1wJTIwUENBJTIwMjAxMCgxKS5jcmww
# bAYIKwYBBQUHAQEEYDBeMFwGCCsGAQUFBzAChlBodHRwOi8vd3d3Lm1pY3Jvc29m
# dC5jb20vcGtpb3BzL2NlcnRzL01pY3Jvc29mdCUyMFRpbWUtU3RhbXAlMjBQQ0El
# MjAyMDEwKDEpLmNydDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUF
# BwMIMA4GA1UdDwEB/wQEAwIHgDANBgkqhkiG9w0BAQsFAAOCAgEAd2cgL2thCjlk
# laQZ2JM1/H/BmY2jrOe+xfaNeAJ4fZSsurUt+MF6D1xMkKdb9YiO6yc2VRu66VM5
# 2stp/XLH596esu5GJB6rUroAhpk4ogZMIRX0gcijyNPDJJYLybyk2W+u98hn6RcD
# 40MGXiOhD4/zgLaWJE+yFF6jJItQkTCSoHmOMFEQnHCLo3VkZKFb+Cd6v/OyhNKj
# 0JgEfX6jDcYyN2QpVcQOMIjN7TVZUWxfUoKTp41aNz/yOafCXeNYTUlQsf/I96jO
# 2i0irQ8zhFDbPmbY4c55mYFHe/wFhw4cAR3S+e0yPYe54mZHzmTl53GLCsRuIK8k
# 7IVOhurAGKW6nTBP/v4Nbnq+1RiB1LS6t1tAJ5vJQH0vT6rYbJGbeeCRdvAh3bBa
# v+11QbRZcS/yoHEMpSTZ4mvmp4sVButMlA7dxTBkiSN+MRvTR7M9waaklrnhrSYU
# OWTdCvI7tLzVYBfg79ObIqz4NH7Uin/RVRAqfd6PKIBePI4fAk/wd9pc9Q+k67pO
# BM3MOxNTobTjH+wx4DzFn+ljnWJ3/h2kice2U1wibFuaDpDNLC4rcQaUqRnI9mI5
# zc5wqbBD2WrdIfune7pUWlkeURwFMhRUPY0WuylmjRnRC07Ppx0pWI2HkKSuUEl4
# 4oHSpS0DwZV/vczqBgCYaGX66Y6uJ0AwggdxMIIFWaADAgECAhMzAAAAFcXna54C
# m0mZAAAAAAAVMA0GCSqGSIb3DQEBCwUAMIGIMQswCQYDVQQGEwJVUzETMBEGA1UE
# CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
# b2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQgUm9vdCBDZXJ0aWZp
# Y2F0ZSBBdXRob3JpdHkgMjAxMDAeFw0yMTA5MzAxODIyMjVaFw0zMDA5MzAxODMy
# MjVaMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
# EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNV
# BAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMIICIjANBgkqhkiG9w0B
# AQEFAAOCAg8AMIICCgKCAgEA5OGmTOe0ciELeaLL1yR5vQ7VgtP97pwHB9KpbE51
# yMo1V/YBf2xK4OK9uT4XYDP/XE/HZveVU3Fa4n5KWv64NmeFRiMMtY0Tz3cywBAY
# 6GB9alKDRLemjkZrBxTzxXb1hlDcwUTIcVxRMTegCjhuje3XD9gmU3w5YQJ6xKr9
# cmmvHaus9ja+NSZk2pg7uhp7M62AW36MEBydUv626GIl3GoPz130/o5Tz9bshVZN
# 7928jaTjkY+yOSxRnOlwaQ3KNi1wjjHINSi947SHJMPgyY9+tVSP3PoFVZhtaDua
# Rr3tpK56KTesy+uDRedGbsoy1cCGMFxPLOJiss254o2I5JasAUq7vnGpF1tnYN74
# kpEeHT39IM9zfUGaRnXNxF803RKJ1v2lIH1+/NmeRd+2ci/bfV+AutuqfjbsNkz2
# K26oElHovwUDo9Fzpk03dJQcNIIP8BDyt0cY7afomXw/TNuvXsLz1dhzPUNOwTM5
# TI4CvEJoLhDqhFFG4tG9ahhaYQFzymeiXtcodgLiMxhy16cg8ML6EgrXY28MyTZk
# i1ugpoMhXV8wdJGUlNi5UPkLiWHzNgY1GIRH29wb0f2y1BzFa/ZcUlFdEtsluq9Q
# BXpsxREdcu+N+VLEhReTwDwV2xo3xwgVGD94q0W29R6HXtqPnhZyacaue7e3Pmri
# Lq0CAwEAAaOCAd0wggHZMBIGCSsGAQQBgjcVAQQFAgMBAAEwIwYJKwYBBAGCNxUC
# BBYEFCqnUv5kxJq+gpE8RjUpzxD/LwTuMB0GA1UdDgQWBBSfpxVdAF5iXYP05dJl
# pxtTNRnpcjBcBgNVHSAEVTBTMFEGDCsGAQQBgjdMg30BATBBMD8GCCsGAQUFBwIB
# FjNodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL0RvY3MvUmVwb3NpdG9y
# eS5odG0wEwYDVR0lBAwwCgYIKwYBBQUHAwgwGQYJKwYBBAGCNxQCBAweCgBTAHUA
# YgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAU
# 1fZWy4/oolxiaNE9lJBb186aGMQwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2Ny
# bC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2VyQXV0XzIw
# MTAtMDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDov
# L3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXRfMjAxMC0w
# Ni0yMy5jcnQwDQYJKoZIhvcNAQELBQADggIBAJ1VffwqreEsH2cBMSRb4Z5yS/yp
# b+pcFLY+TkdkeLEGk5c9MTO1OdfCcTY/2mRsfNB1OW27DzHkwo/7bNGhlBgi7ulm
# ZzpTTd2YurYeeNg2LpypglYAA7AFvonoaeC6Ce5732pvvinLbtg/SHUB2RjebYIM
# 9W0jVOR4U3UkV7ndn/OOPcbzaN9l9qRWqveVtihVJ9AkvUCgvxm2EhIRXT0n4ECW
# OKz3+SmJw7wXsFSFQrP8DJ6LGYnn8AtqgcKBGUIZUnWKNsIdw2FzLixre24/LAl4
# FOmRsqlb30mjdAy87JGA0j3mSj5mO0+7hvoyGtmW9I/2kQH2zsZ0/fZMcm8Qq3Uw
# xTSwethQ/gpY3UA8x1RtnWN0SCyxTkctwRQEcb9k+SS+c23Kjgm9swFXSVRk2XPX
# fx5bRAGOWhmRaw2fpCjcZxkoJLo4S5pu+yFUa2pFEUep8beuyOiJXk+d0tBMdrVX
# VAmxaQFEfnyhYWxz/gq77EFmPWn9y8FBSX5+k77L+DvktxW/tM4+pTFRhLy/AsGC
# onsXHRWJjXD+57XQKBqJC4822rpM+Zv/Cuk0+CQ1ZyvgDbjmjJnW4SLq8CdCPSWU
# 5nR0W2rRnj7tfqAxM328y+l7vzhwRNGQ8cirOoo6CGJ/2XBjU02N7oJtpQUQwXEG
# ahC0HVUzWLOhcGbyoYIDUDCCAjgCAQEwgfmhgdGkgc4wgcsxCzAJBgNVBAYTAlVT
# MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
# ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJTAjBgNVBAsTHE1pY3Jvc29mdCBBbWVy
# aWNhIE9wZXJhdGlvbnMxJzAlBgNVBAsTHm5TaGllbGQgVFNTIEVTTjpFMDAyLTA1
# RTAtRDk0NzElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZaIj
# CgEBMAcGBSsOAwIaAxUAiKOm1Tb35RcW1Fgg0N2GCsujvpOggYMwgYCkfjB8MQsw
# CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
# ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNy
# b3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDANBgkqhkiG9w0BAQsFAAIFAOmwHmow
# IhgPMjAyNDAzMjgxNjUwNTBaGA8yMDI0MDMyOTE2NTA1MFowdzA9BgorBgEEAYRZ
# CgQBMS8wLTAKAgUA6bAeagIBADAKAgEAAgIT6wIB/zAHAgEAAgITEzAKAgUA6bFv
# 6gIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMCoAowCAIBAAIDB6Eg
# oQowCAIBAAIDAYagMA0GCSqGSIb3DQEBCwUAA4IBAQBoEpPZ/1BfGJRwO1mACEVk
# PMxUxKjR7k5nxg2maXmv9FrV3MRC9JGbY2cWdHxW3itfZSG6ZlD2/AobhJ6i6vRl
# KgdjyZKHX7Lv9g02sJZCWGMVHgMF9mvxf4d6115+4FfH2xxgg3NHyw8rXQAGlCBD
# jGolqoNUZvCkF5YNdm40IXwEFyWJCV+2Jo5MyxDZi75fpfG0FyHVtpTcIYWP0h3B
# jXrZVm8kyT5s2qXOFGR8B4C9iCipuxg4f7V5Dc3WSYz29KIlUZwER+LygNWBNDHY
# c5Iy3rZ6y3+tNDkzewI+3sDZNs3Blm+1zQsn7OLkwA83EGkcLgQfdzCfrcwyMbyK
# MYIEDTCCBAkCAQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
# b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
# dGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMA
# AAHuBdMCMLKanacAAQAAAe4wDQYJYIZIAWUDBAIBBQCgggFKMBoGCSqGSIb3DQEJ
# AzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQgdKtltECsD/EDzCUbVOQ7
# lNDg205eg/cniFaPMqZ0jhYwgfoGCyqGSIb3DQEJEAIvMYHqMIHnMIHkMIG9BCBP
# UHcUlYX6vlXX/gz7PuRCJAc/aAkvzkH5R5FUYX4wITCBmDCBgKR+MHwxCzAJBgNV
# BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
# HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29m
# dCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAB7gXTAjCymp2nAAEAAAHuMCIEIMal
# hitxayAHDwii9JXOarv6eJKYl5EOMvW3yyEWLF3FMA0GCSqGSIb3DQEBCwUABIIC
# AI/+pQMRbdwruHPEr7zyvbG+Pw+haC8whalBogEoD0Eqkak9fk3Hx+JEi6hfaDm8
# ejydP3bXu66wUuYTfTeLcQAg7IQCerV/Zy6DY4oaOamHAS54lWJMu6cACYeiCRu8
# H8TVFUX0YaqxmnhqgxRzDnw40/TAijoGnFTHMnsPeO44qOTOFpP9d8rvv/nczb5m
# nbMSDbG5frC5y4hR5XLHoLf9HpunDfdVx8UGGjSdqfkKVzIar4yznUSrGm4QugXM
# NvQ26rwqEdZSV5AWQgcB/kaDU0YMJ6RBZNNyIpxzW/P6haKk6JxFrUytg8GYVnaU
# aB23z2ue8mbr9zKdA9Msnf6GC8xTKmrudDY9LmCa8aiKa/98H5oLHX/05lu4n2aT
# LdnSuniqjQmve3QDZ2IZIOErAaMvEXt+NyW4jCu2R94mV8zJsq5a7dyXa+WcrIWp
# 7IyHUhCI+7VxayOqirFgR9OdC3Q0Amx4/iFukKTdwHmGLLGR520/kBDKUQpUy8Ui
# AfOzkmP/NVEW316zmJRliudz3fciII31a0sNhDxSjQab20vyhCgWDCvEeiex/CrC
# nRi/MCGEBdC7h6DOY3spTzV9KTE4AoabWgDOzCda34YW90O+8sZkwtjW/Gf7o/do
# S9NtT4JqTphGe+6CF4a5by7Pk87cXnitkUCROnfJmO2o
# SIG # End signature block
